//
//  QuestionController.swift
//  HCSStudies
//
//  Created by Marvin Kowalewski on 26.06.23.
//

import Foundation
import UIKit

struct Question {
    var questionString: String?
    var answers: [String]?
    var selectedAnswerIndex: Int?
}

class QuestionController: UIViewController {
    
    
    @IBOutlet var questionLabel: UILabel!
    
    @IBOutlet var answersStackView: UIStackView!
    
    let button = UIButton()
    let button2 = UIButton()
    let button3 = UIButton()
    let continueButton = UIButton()
    
    let cellId = "cellId"
    let headerId = "headerId"

    override func viewDidLoad() {
        super.viewDidLoad()
        
        question1()
    
    }
    
    
    func question1() {
        questionLabel.text = "Wie häufig am Tag entsperren Sie Ihr Smartphone?"
       
        continueButton.setTitle("Weiter", for: .normal)
        button.backgroundColor = UIColor.green
        button.translatesAutoresizingMaskIntoConstraints = false
    
    button.setTitle("1 - Weniger als einmal am Tag", for: .normal)
        button.isEnabled = true
    button.backgroundColor = UIColor.green
    button.setTitleColor(.black, for: .normal)
    button.translatesAutoresizingMaskIntoConstraints = false

     
     button2.setTitle("2 - Mehr als einmal am Tag", for: .normal)
     button2.backgroundColor = UIColor.clear
        button2.setTitleColor(.black, for: .normal)
        button2.contentHorizontalAlignment = UIControl.ContentHorizontalAlignment.left
     button2.translatesAutoresizingMaskIntoConstraints = false

     
     button3.setTitle("3 - Mehr als einmal pro Stunde", for: .normal)
     button3.backgroundColor = UIColor.clear
        button3.setTitleColor(.black, for: .normal)
        button3.contentHorizontalAlignment = UIControl.ContentHorizontalAlignment.left
     button3.translatesAutoresizingMaskIntoConstraints = false

        answersStackView.alignment = .fill
        answersStackView.distribution = .fillEqually
        answersStackView.spacing = 15.0

        answersStackView.addArrangedSubview(button)
        answersStackView.addArrangedSubview(button2)
        answersStackView.addArrangedSubview(button3)
        
        answersStackView.addArrangedSubview(continueButton)
        
        
        answersStackView.addSeparators(at: [2], color: .black)
        answersStackView.addSeparators(at: [1], color: .black)
        
        button.addTarget(self, action: #selector(self.buttonTapped), for: .touchUpInside)


    }
    
    @objc func buttonTapped(sender : UIButton) {
        button.backgroundColor = .blue
                    //Write button action here
    }
    
    //target functions
    @objc func heldDown()
    {
        button.backgroundColor = .yellow
    }

    @objc func holdRelease()
    {
        button.backgroundColor = .systemPink
    }

    @objc func buttonHeldAndReleased(){
        button.backgroundColor = .blue
    }
    
}



extension UIStackView {
    
    func addSeparators(at positions: [Int], color: UIColor) {
        for position in positions {
            let separator = UIView()
            separator.backgroundColor = color
            
            insertArrangedSubview(separator, at: position)
            switch self.axis {
            case .horizontal:
                separator.widthAnchor.constraint(equalToConstant: 0.2).isActive = true
                separator.heightAnchor.constraint(equalTo: self.heightAnchor, multiplier: 1).isActive = true
            case .vertical:
                separator.heightAnchor.constraint(equalToConstant: 1).isActive = true
                separator.widthAnchor.constraint(equalTo: self.widthAnchor, multiplier: 1).isActive = true
            @unknown default:
                fatalError("Unknown UIStackView axis value.")
            }
        }
    }
}
